Attribute VB_Name = "Module1"
Option Explicit

Public Declare Function GetTickCount Lib "kernel32" () As Long
Public Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

Public CFdata As Double
Public SPdata As Double
Public REFdata As Double
Public ROFdata As Double

Public MeasFlag As Integer

Public MKR1Freq As Double
Public MKR2Freq As Double
Public MKR3Freq As Double
Public CHSPdata As Double

Public MTdata As Double
Public TIdata As Double
Public MeasCountMax As Long
Public MeasNumber As Long
Public DataNumber As Long
Public SaveFileText As String

Public SetupLAN As Integer
Public SetupSpaOK As Integer
Public FreqUnitsData As Integer
Public MeasModeData As Integer
Public RefUnitsData As Integer
Public MaxMinData As Integer
Public DataSaveData As Integer

Public FreqUnits As String * 3
Public RefUnits As String * 5
Public sDate As String * 11
Public sTime As String * 9

Public MeasData() As String
Public MeasAllData() As String

Public MKR1data As String
Public MKR2data As String
Public MKR3data As String
Public MKR1min As String

Public PK1Freq As String
Public PK2Freq As String
Public PK3Freq As String

Public IPadrs As String
Public Portadrs As String



Public Sub MeasSetup()
Dim SendDt As String, ErrRet As Integer

    CFdata = Val(FormMeas.CenterFreq)
    SPdata = Val(FormMeas.SpanFreq)
    REFdata = Val(FormMeas.RefLevel)
    ROFdata = Val(FormMeas.OffsetLvl)

    MKR1Freq = Val(FormMeas.Marker1)
    MKR2Freq = Val(FormMeas.Marker2)
    MKR3Freq = Val(FormMeas.Marker3)

    CHSPdata = Val(FormMeas.CHspan)
    
    MTdata = Val(FormMeas.MeasTime)
    TIdata = Val(FormMeas.TimeInter)
    
    '------------------------------------------- UNITS Check
    If FormMeas.Option1.Value = True Then
        FreqUnits = " GZ"
        FreqUnitsData = 1
    End If
    If FormMeas.Option2.Value = True Then
        FreqUnits = " MZ"
        FreqUnitsData = 2
    End If
    If FormMeas.Option3.Value = True Then
        FreqUnits = " KZ"
        FreqUnitsData = 3
    End If
    If FormMeas.Option4.Value = True Then
        RefUnits = "  DBM"
        RefUnitsData = 1
    End If
    If FormMeas.Option5.Value = True Then
        RefUnits = " DBUV"
        RefUnitsData = 2
    End If
    '------------------------------------------- Mode Check
    If FormMeas.MaxCheck.Value = 1 Then
        MaxMinData = 1
    Else
        MaxMinData = 0
    End If
    If FormMeas.SaveCheck.Value = 1 Then
        DataSaveData = 1
    Else
        DataSaveData = 0
    End If
    If FormMeas.Option6.Value = True Then MeasModeData = 1      'fixed
    If FormMeas.Option9.Value = True Then MeasModeData = 2      'Zone
    If FormMeas.Option7.Value = True Then MeasModeData = 3      'Peak
    If FormMeas.Option8.Value = True Then MeasModeData = 4      'CH Power
    '-------------------------------------------------------
    
    
    SendDt = "REN" + vbLf                                 'Remote ON
    ErrRet = Form1.SendDtFunc(SendDt)
    If ErrRet <> 0 Then Exit Sub
    
    SendDt = "MKOFF;MKSX OFF;DY 0.5;PMEASOFF" + vbLf      'Reset Measurement1
    ErrRet = Form1.SendDtFunc(SendDt)
    If ErrRet <> 0 Then Exit Sub
    
    SendDt = "AL;AW;CALCA WRITE;BB;CALCB WRITE" + vbLf    'Reset Measurement2
    ErrRet = Form1.SendDtFunc(SendDt)
    If ErrRet <> 0 Then Exit Sub
    
    
    
    SendDt = "CF" + Format(CFdata) + FreqUnits + vbLf   'CF
    ErrRet = Form1.SendDtFunc(SendDt)
    If ErrRet <> 0 Then Exit Sub
    
    SendDt = "SP" + Format(SPdata) + FreqUnits + vbLf   'SP
    ErrRet = Form1.SendDtFunc(SendDt)
    If ErrRet <> 0 Then Exit Sub
    
    If ROFdata <> 0 Then
        SendDt = "RO ON; RO" + Format(ROFdata) + "DB" + vbLf   'Offset
    Else
        SendDt = "RO OFF" + vbLf
    End If
    ErrRet = Form1.SendDtFunc(SendDt)
    If ErrRet <> 0 Then Exit Sub
    
    SendDt = "RL" + Format(REFdata) + RefUnits + vbLf   'Ref
    ErrRet = Form1.SendDtFunc(SendDt)
    If ErrRet <> 0 Then Exit Sub
    
    
    If MeasModeData = 2 Then                            'Zone Marker
        SendDt = "MKSX IN;WLX" + Format(CFdata) + FreqUnits + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        SendDt = "WDX" + Format(SPdata / 10) + FreqUnits + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
    End If
    

    If MeasModeData = 4 Then                            'CH Power
    
    
        SendDt = "WLX" + Format(CFdata) + FreqUnits + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub

        SendDt = "WDX" + Format(CHSPdata) + FreqUnits + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
    
        SendDt = "RB 1MZ;VB 1MZ;SW 100MS" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
    
        SendDt = "PWCHON ON" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        
    Else
    
        If MaxMinData = 1 Then                          'Max Min --> set B
            SendDt = "CALCA MAX;BW;CALCB MIN" + vbLf
            ErrRet = Form1.SendDtFunc(SendDt)
            If ErrRet <> 0 Then Exit Sub
        End If
    
    End If
    
    SetupSpaOK = 1                                      'Setting data is OK for Save


End Sub

Public Sub Measurement()

Dim SendDt As String, ErrRet As Integer


    PK2Freq = " "
    PK3Freq = " "
    MKR2data = " "
    MKR3data = " "
    MKR1min = " "
    
    
    If MeasModeData = 1 Then                            'Fixed Marker
    
        If MaxMinData = 1 Then                          'AB View
            SendDt = "AV;BV" + vbLf
        Else
            SendDt = "AV" + vbLf                        'A View
        End If
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
    
        SendDt = "MLN1 ON" + vbLf                       'Marker 1 ON
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
    
        SendDt = "MK " + Format(MKR1Freq) + FreqUnits + vbLf    'MKR1
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        SendDt = "MF?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(PK1Freq)              ' MK Frequency
        If ErrRet <> 0 Then Exit Sub
        SendDt = "ML?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(MKR1data)             ' MK Level
        If ErrRet <> 0 Then Exit Sub
        
        If MaxMinData = 1 Then                          ' MaxMin
            SendDt = "MKTRACE TRB;ML?" + vbLf           ' B Trace
            ErrRet = Form1.SendDtFunc(SendDt)
            If ErrRet <> 0 Then Exit Sub
            ErrRet = Form1.ReadDtFunc(MKR1min)          ' MK1 Min Level
            If ErrRet <> 0 Then Exit Sub
            SendDt = "MKTRACE TRA" + vbLf               ' A Trace
            ErrRet = Form1.SendDtFunc(SendDt)
            If ErrRet <> 0 Then Exit Sub
        Else
            MKR1min = "0"
        End If
        
        SendDt = "MK " + Format(MKR2Freq) + FreqUnits + vbLf    'MKR2
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        SendDt = "MF?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(PK2Freq)              ' MK Frequency
        If ErrRet <> 0 Then Exit Sub
        SendDt = "ML?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(MKR2data)             ' MK Level
        If ErrRet <> 0 Then Exit Sub
        
        SendDt = "MK " + Format(MKR3Freq) + FreqUnits + vbLf    'MKR3
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        SendDt = "MF?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(PK3Freq)              ' MK Frequency
        If ErrRet <> 0 Then Exit Sub
        SendDt = "ML?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(MKR3data)             ' MK Level
        If ErrRet <> 0 Then Exit Sub
                                
                                
        If MaxMinData = 1 Then                          'AB Write and MaxMin
            SendDt = "AW;CALCA MAX;BW;CALCB MIN" + vbLf
        Else
            SendDt = "AW" + vbLf                        'A Write
        End If
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
    
    End If
    
    
    
    If MeasModeData = 2 Then                            'Zone Marker
    
        If MaxMinData = 1 Then                          'AB View
            SendDt = "AV;BV" + vbLf
        Else
            SendDt = "AV" + vbLf                        'A View
        End If
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
    
        SendDt = "MLN1 ON" + vbLf                       'Marker 1 ON
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
    
        SendDt = "MK " + Format(MKR1Freq) + FreqUnits + vbLf    'MKR1
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        
        SendDt = "WLX" + Format(MKR1Freq) + FreqUnits
        SendDt = SendDt + ";WDX" + Format(SPdata / 10) + FreqUnits + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        SendDt = "PS" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        
        SendDt = "MF?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(PK1Freq)              ' MK Frequency
        If ErrRet <> 0 Then Exit Sub
        SendDt = "ML?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(MKR1data)             ' MK Level
        If ErrRet <> 0 Then Exit Sub
        
        If MaxMinData = 1 Then                          ' MaxMin
            SendDt = "MKTRACE TRB;ML?" + vbLf           ' B Trace
            ErrRet = Form1.SendDtFunc(SendDt)
            If ErrRet <> 0 Then Exit Sub
            ErrRet = Form1.ReadDtFunc(MKR1min)          ' MK1 Min Level
            If ErrRet <> 0 Then Exit Sub
            SendDt = "MKTRACE TRA" + vbLf               ' A Trace
            ErrRet = Form1.SendDtFunc(SendDt)
            If ErrRet <> 0 Then Exit Sub
        Else
            MKR1min = "0"
        End If
        
        SendDt = "MK " + Format(MKR2Freq) + FreqUnits + vbLf    'MKR2
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        
        SendDt = "WLX" + Format(MKR2Freq) + FreqUnits
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        SendDt = "PS" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        
        SendDt = "MF?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(PK2Freq)              ' MK Frequency
        If ErrRet <> 0 Then Exit Sub
        SendDt = "ML?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(MKR2data)             ' MK Level
        If ErrRet <> 0 Then Exit Sub
        
        SendDt = "MK " + Format(MKR3Freq) + FreqUnits + vbLf    'MKR3
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        
        SendDt = "WLX" + Format(MKR3Freq) + FreqUnits
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        SendDt = "PS" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        
        SendDt = "MF?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(PK3Freq)              ' MK Frequency
        If ErrRet <> 0 Then Exit Sub
        SendDt = "ML?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(MKR3data)             ' MK Level
        If ErrRet <> 0 Then Exit Sub
                                
                                
        If MaxMinData = 1 Then                          'AB Write and MaxMin
            SendDt = "AW;CALCA MAX;BW;CALCB MIN" + vbLf
        Else
            SendDt = "AW" + vbLf                        'A Write
        End If
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
    
    End If
    
    
    
    If MeasModeData = 3 Then                            'Peak Search
    
        If MaxMinData = 1 Then                          'AB View
            SendDt = "AV;BV" + vbLf
        Else
            SendDt = "AV" + vbLf                        'A View
        End If
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
    
        SendDt = "PS" + vbLf                            'PS
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        SendDt = "MF?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(PK1Freq)              ' MK Frequency
        If ErrRet <> 0 Then Exit Sub
        SendDt = "ML?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(MKR1data)             ' MK Level
        If ErrRet <> 0 Then Exit Sub
        
        If MaxMinData = 1 Then                          ' MaxMin
            SendDt = "MKTRACE TRB;ML?" + vbLf           ' B Trace
            ErrRet = Form1.SendDtFunc(SendDt)
            If ErrRet <> 0 Then Exit Sub
            ErrRet = Form1.ReadDtFunc(MKR1min)          ' MK1 Min Level
            If ErrRet <> 0 Then Exit Sub
            SendDt = "MKTRACE TRA" + vbLf               ' A Trace
            ErrRet = Form1.SendDtFunc(SendDt)
            If ErrRet <> 0 Then Exit Sub
        Else
            MKR1min = "0"
        End If
    
        SendDt = "NXP" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        SendDt = "MF?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(PK2Freq)              ' MK Frequency
        If ErrRet <> 0 Then Exit Sub
        SendDt = "ML?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(MKR2data)             ' MK Level
        If ErrRet <> 0 Then Exit Sub
        
        SendDt = "NXP" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        SendDt = "MF?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(PK3Freq)              ' MK Frequency
        If ErrRet <> 0 Then Exit Sub
        SendDt = "ML?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(MKR3data)             ' MK Level
        If ErrRet <> 0 Then Exit Sub
        
        
        If MaxMinData = 1 Then                          'AB Write and MaxMin
            SendDt = "AW;CALCA MAX;BW;CALCB MIN" + vbLf
        Else
            SendDt = "AW" + vbLf                        'A Write
        End If
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub

    End If
   
   
   
    If MeasModeData = 4 Then                             'CH Power
    
        SendDt = "PWCH?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(MKR1data)
        If ErrRet <> 0 Then Exit Sub
        
        SendDt = "WLX?" + vbLf
        ErrRet = Form1.SendDtFunc(SendDt)
        If ErrRet <> 0 Then Exit Sub
        ErrRet = Form1.ReadDtFunc(PK1Freq)              ' MK Frequency
        If ErrRet <> 0 Then Exit Sub
        
    End If
    
        
    Call DataToBuffer                                   ' Data Display & Save
    
    
End Sub

Sub DataToBuffer()
Dim CommentData As String
Dim i As Integer
Dim DispBuf As String

    ReDim MeasData(9)
    
    sDate = Date$
    sTime = Time$
    
    If FormMeas.CommentIn.Value = 1 Then
        CommentData = FormMeas.TextMkr.Text + " "
        ' FormMeas.TextMkr.Text = ""
        FormMeas.CommentIn.Value = 0
    Else
        CommentData = " "
    End If

    '-------------------------------------------
    
    MeasData(0) = sDate
    MeasData(1) = sTime
    MeasData(2) = Format(PK1Freq, "###########")
    MeasData(3) = Format(MKR1data, "####0.00")
    MeasData(4) = Format(MKR1min, "####0.00")
    MeasData(5) = Format(PK2Freq, "###########")
    MeasData(6) = Format(MKR2data, "####0.00")
    MeasData(7) = Format(PK3Freq, "###########")
    MeasData(8) = Format(MKR3data, "####0.00")
    MeasData(9) = CommentData
     
    '-------------------------------------------
    
    If MeasNumber = 1 Then
        ReDim MeasAllData(10)
    Else
        ReDim Preserve MeasAllData(MeasNumber * 10)
    End If
    
    
    DataNumber = ((MeasNumber - 1) * 10)
    
    For i = 0 To 9
        MeasAllData(DataNumber) = MeasData(i)
        DataNumber = DataNumber + 1
    Next i
    
    
    '-------------------------------------------------------------
    'Display
    'FormMeas.TextRslt.SelStart = Len(FormMeas.TextRslt.Text)    'Display Position Counter
    
    For i = 0 To 8
        
        FormMeas.TextRslt.SelText = MeasData(i) & " ,  "
        DispBuf = DispBuf & MeasData(i) & " ,  "
        
    Next i
    
    FormMeas.TextRslt.SelText = MeasData(9) & vbCrLf            'List Display
    FormMeas.Text1.Text = DispBuf & MeasData(9) & vbCrLf        'Text Display
    

End Sub


Public Sub SaveData()
Dim jj As Long

On Error GoTo ErrProcData

    If DataSaveData = 1 Then
    
        SaveFileText = FormMeas.SaveText.Text
        SaveFileText = SaveFileText + "\Data" + Format(Now, "mmddhhnn") + ".csv"
        
        jj = 0
        
        Open SaveFileText For Output As #1
        
            Do Until jj >= DataNumber
                            
                Write #1, MeasAllData(jj); MeasAllData(jj + 1); MeasAllData(jj + 2); MeasAllData(jj + 3); MeasAllData(jj + 4); MeasAllData(jj + 5); MeasAllData(jj + 6); MeasAllData(jj + 7); MeasAllData(jj + 8); MeasAllData(jj + 9)
                
                jj = jj + 10
                
            Loop
                
        Close #1
        
        Form1.sbrMessage.SimpleText = "Save the data: Done..."
        MeasFlag = 0                                            'End of Save and Measurement
        
    Else
    
        Form1.sbrMessage.SimpleText = "The Auto Save was not selected."
        MeasFlag = 0                                            'End of No_Save and Measurement
    
    End If
    
    Exit Sub                                                    'EXIT------------
    
ErrProcData:                                                    'Error : Still MeasFlag = 1
    Close #1
    Form1.sbrMessage.SimpleText = "Error: The save directory name was not found."
    
    MsgBox "Error: Please check the save directory name... and Retry!", vbQuestion, App.Title
    

End Sub


Public Sub InitSave()

Dim InitFileDir As String

On Error GoTo ErrProcSave

    If SetupSpaOK = 1 Then
    
        Form1.sbrMessage.SimpleText = "Save the setting data... done"
    
        SaveFileText = FormMeas.SaveText.Text
        IPadrs = Form1.txtHost.Text
        Portadrs = Form1.txtPort.Text
        
        InitFileDir = App.Path + "\TrendInit.dat"
        
        Open InitFileDir For Output As #1
        
            Write #1, CFdata; SPdata; REFdata; ROFdata; MKR1Freq; MKR2Freq; MKR3Freq; CHSPdata; MTdata; TIdata
            Write #1, MeasModeData; FreqUnitsData; RefUnitsData; MaxMinData; DataSaveData
            Write #1, SaveFileText; IPadrs; Portadrs
    
        Close #1
        
    Else
        
        Form1.sbrMessage.SimpleText = ""
        
    End If
    
    Exit Sub                                                    'EXIT------------
    
ErrProcSave:                                                    'ERROR
    Close #1
    Form1.sbrMessage.SimpleText = "Error: The save directory name was not found."
    
End Sub


Public Sub InitRecall()

Dim InitFileDir As String

Form1.sbrMessage.SimpleText = "Recall setting data... done "

On Error GoTo ErrProcRecall

    InitFileDir = App.Path + "\TrendInit.dat"

    Open InitFileDir For Input As #1
    
        Input #1, CFdata, SPdata, REFdata, ROFdata, MKR1Freq, MKR2Freq, MKR3Freq, CHSPdata, MTdata, TIdata
        Input #1, MeasModeData, FreqUnitsData, RefUnitsData, MaxMinData, DataSaveData
        Input #1, SaveFileText, IPadrs, Portadrs
        
    Close #1
    
    '-----------------------------------Setup Initial Data
    
    FormMeas.CenterFreq.Text = CFdata
    FormMeas.SpanFreq.Text = SPdata
    FormMeas.RefLevel.Text = REFdata
    FormMeas.OffsetLvl.Text = ROFdata
    FormMeas.Marker1.Text = MKR1Freq
    FormMeas.Marker2.Text = MKR2Freq
    FormMeas.Marker3.Text = MKR3Freq
    FormMeas.CHspan.Text = CHSPdata
    FormMeas.MeasTime.Text = MTdata
    FormMeas.TimeInter.Text = TIdata
    
    If MeasModeData = 1 Then FormMeas.Option6.Value = True      'Mode Group
    If MeasModeData = 2 Then FormMeas.Option9.Value = True
    If MeasModeData = 3 Then FormMeas.Option7.Value = True
    If MeasModeData = 4 Then FormMeas.Option8.Value = True
    
    If FreqUnitsData = 1 Then FormMeas.Option1.Value = True     'F Units Group
    If FreqUnitsData = 2 Then FormMeas.Option2.Value = True
    If FreqUnitsData = 3 Then FormMeas.Option3.Value = True
    
    If RefUnitsData = 1 Then FormMeas.Option4.Value = True      'L Units Group
    If RefUnitsData = 2 Then FormMeas.Option5.Value = True
    
    FormMeas.MaxCheck.Value = MaxMinData
    FormMeas.SaveCheck.Value = DataSaveData
    
    FormMeas.SaveText.Text = SaveFileText
    
    Form1.txtHost = IPadrs
    Form1.txtPort = Portadrs
    
    Exit Sub                                                    'EXIT-----------------
    
ErrProcRecall:                                                  'Error
    Close #1
    Form1.sbrMessage.SimpleText = "The initial data file was not found.... (First boot)"

End Sub
